// Input processing (ievades apstrāde)
if (!global.pause) {  // Ja spēle nav pauzēta
    getControls();  // Iegūst spēles vadības ievades

    // Dash loģika (paātrinājums)
    if (global.canDash && dashCooldownTimer <= 0) {  // Ja var izmantot dash un cooldown ir beidzies
        if (keyboard_check_pressed(vk_shift)) {  // Ja tiek nospiesta shift taustiņš
            dashTimer = global.dashDuration;  // Sāk dash
            dashCooldownTimer = global.dashCooldown;  // Iestata cooldown
        }
    }

    if (dashTimer > 0) {  // Ja dash ir aktīvs
        xspd = face * global.dashSpeed;  // Iestatām horizontālo ātrumu atbilstoši dashing ātrumam
        dashTimer--;  // Samazinām dash taimeri
    } else {
        dashCooldownTimer--;  // Samazinām cooldown taimeri
        // Atjaunojam x ātrumu pēc dashing
        if (dashCooldownTimer <= 0 && onGround) {  // Ja cooldown ir beidzies un spēlētājs ir uz zemes
            xspd = 0;  // Atjauno x ātrumu uz nulli
        }
    }

    // X kustība (horizontālā kustība)
    if (onGround && !isChargingJump && dashTimer <= 0) {  // Ja spēlētājs ir uz zemes, nav lēkšanas uzlādes un nav aktīvs dash
        moveDir = rightkey - leftkey;  // Kustības virziens (pa labi - pa kreisi)
        if (moveDir != 0) {  // Ja kustība ir pamanīta
            face = moveDir;  // Maina spēlētāja virzienu
        }
        xspd = moveDir * global.moveSpd;  // Izmanto kustības ātrumu
    } else if (isChargingJump && dashTimer <= 0) {  // Ja spēlētājs uzlādē lēcienu un dash nav aktīvs
        jumpDirection = rightkey - leftkey;  // Lēciena virziens
        xspd = 0;  // Uzstāda horizontālo ātrumu uz nulli (jo nav kustības)

        if (jumpDirection != 0) {  // Ja tiek uzlādēts lēciens
            face = jumpDirection;  // Maina spēlētāja virzienu
        }
    }

    // Piemēro X ātrumu (horizontālās kolīzijas pārbaude)
    if (onGround && dashTimer <= 0) {  // Ja spēlētājs ir uz zemes un dash ir beidzies
        if (!place_meeting(x + xspd, y, oWall)) {  // Ja nav kolīzijas ar sienu
            x += xspd;  // Pārvieto spēlētāju
        } else {
            xspd = 0;  // Ja ir kolīzija, atjauno ātrumu uz nulli
        }
    }

    // Y kustība (vertikālā kustība)
    if (onGround && dashTimer <= 0) {  // Ja spēlētājs ir uz zemes un dash nav aktīvs
        if (jumpKey) {  // Ja tiek nospiests lēkšanas taustiņš
            isChargingJump = true;  // Sāk lēciena uzlādi
            jumpCharge += 1;  // Palielina lēciena uzlādes vērtību
            if (jumpCharge > maxJumpCharge) jumpCharge = maxJumpCharge;  // Ierobežo lēciena uzlādes maksimālo vērtību
            show_debug_message("Charging jump: " + string(jumpCharge));  // Debug ziņa
        }

        if ((!jumpKey && isChargingJump) || jumpCharge == maxJumpCharge) {  // Ja taustiņš tiek atlaists vai lēciens ir pilnībā uzlādēts
            if (jumpCharge >= minJumpCharge) {  // Ja uzlāde ir pietiekama
                yspd = lerp(global.jspd[1], global.jspd[0], (jumpCharge - minJumpCharge) / (maxJumpCharge - minJumpCharge));  // Lēkšanas ātrums
                jumpSpeed = jumpDirection * (global.moveSpd + 2);  // Lēkšanas ātruma korekcija
                xspd = jumpSpeed;  // Iekļauj horizontālo ātrumu lēcienā
                onGround = false;  // Spēlētājs ir gaisā
            }
            isChargingJump = false;  // Apstājas lēciena uzlāde
            jumpCharge = 0;  // Nullē lēciena uzlādes vērtību
        }
    } else {
        yspd += grav;  // Ja nav uz zemes, piemēro gravitāciju
    }

    // Sienas atsitiens
    if (!onGround && dashTimer <= 0 && place_meeting(x + xspd, y, oWall)) {  // Ja spēlētājs nav uz zemes un ir kolīzija ar sienu
        xspd = -xspd * global.bounceBack;  // Atsitiena efekts uz horizontālo ātrumu
        yspd = yspd * 1;  // Saglabā vertikālo ātrumu nemainīgu

        var _pixelCheck = sign(xspd) * -1;  // Pixel pārbaude
        while (place_meeting(x + _pixelCheck, y, oWall)) {  // Kamēr ir kolīzija ar sienu
            x -= _pixelCheck;  // Koriģē spēlētāja pozīciju
        }
    }

    // Termināla ātruma ierobežojums (maksimālais kritiena ātrums)
    if (yspd > termVel) {
        yspd = termVel;  // Ierobežo vertikālo ātrumu
    }

    // Y kolīzijas pārbaude
    if (place_meeting(x, y + yspd, oWall)) {  // Ja ir kolīzija ar sienu vertikāli
        var _pixelCheck = sign(yspd) * 0.5;  // Pixel pārbaude
        while (!place_meeting(x, y + _pixelCheck, oWall)) {  // Kamēr nav kolīzijas
            y += _pixelCheck;  // Koriģē vertikālo pozīciju
        }

        if (yspd < 0) {  // Ja spēlētājs iet uz augšu
            jumpHoldTimer = 0;  // Atjauno lēciena turēšanas taimeri
        }
        yspd = 0;  // Atsitiena gadījumā noliek vertikālo ātrumu uz nulli
    }

    // Piemēro X un Y ātrumus
    x += xspd;  // Atjauno spēlētāja horizontālo pozīciju
    y += yspd;  // Atjauno spēlētāja vertikālo pozīciju

    // Pārbauda, vai spēlētājs atrodas uz zemes
    if (place_meeting(x, y + 1, oWall) && !place_meeting(x, y, oWall)) {
        onGround = true;  // Ja ir saskare ar zemes virsmu, spēlētājs atrodas uz zemes
    } else {
        onGround = false;  // Ja nav saskares ar zemes virsmu, spēlētājs ir gaisā
    }

    // Sprite kontrole
    if (isChargingJump) {
        sprite_index = chargeSpr;  // Ja tiek uzlādēts lēciens, parāda uzlādes sprite
    } else if (abs(xspd) > 0 && !isChargingJump) {
        sprite_index = walkSpr;  // Ja spēlētājs kustas, parāda staigāšanas sprite
    } else if (xspd == 0 && !isChargingJump) {
        sprite_index = idleSpr;  // Ja spēlētājs stāv, parāda stāvēšanas sprite
    } else if (!onGround) {
        sprite_index = jumpSpr;  // Ja spēlētājs lēkā, parāda lēkšanas sprite
    }
}

// Iestata kolīzijas masku
mask_index = maskSpr;  // Uzstāda spēlētāja masku
